package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{LocationStringModel, FleetIdOrArn}
import scala.jdk.CollectionConverters._
final case class DescribeFleetPortSettingsRequest(
    fleetId: FleetIdOrArn,
    location: Optional[LocationStringModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsRequest = {
    import DescribeFleetPortSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeFleetPortSettingsRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetPortSettingsRequest
      .wrap(buildAwsValue())
}
object DescribeFleetPortSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeFleetPortSettingsRequest =
      zio.aws.gamelift.model
        .DescribeFleetPortSettingsRequest(fleetId, location.map(value => value))
    def fleetId: FleetIdOrArn
    def location: Optional[LocationStringModel]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsRequest
  ) extends zio.aws.gamelift.model.DescribeFleetPortSettingsRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val location: Optional[LocationStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsRequest
  ): zio.aws.gamelift.model.DescribeFleetPortSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
