package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  ArnStringModel,
  FleetIdOrArn,
  PositiveInteger,
  LocationStringModel,
  NonZeroAndMaxString,
  AliasIdOrArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeGameSessionDetailsRequest(
    fleetId: Optional[FleetIdOrArn] = Optional.Absent,
    gameSessionId: Optional[ArnStringModel] = Optional.Absent,
    aliasId: Optional[AliasIdOrArn] = Optional.Absent,
    location: Optional[LocationStringModel] = Optional.Absent,
    statusFilter: Optional[NonZeroAndMaxString] = Optional.Absent,
    limit: Optional[PositiveInteger] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest = {
    import DescribeGameSessionDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetIdOrArn.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        gameSessionId.map(value =>
          ArnStringModel.unwrap(value): java.lang.String
        )
      )(_.gameSessionId)
      .optionallyWith(
        aliasId.map(value => AliasIdOrArn.unwrap(value): java.lang.String)
      )(_.aliasId)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .optionallyWith(
        statusFilter.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.statusFilter)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeGameSessionDetailsRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeGameSessionDetailsRequest
      .wrap(buildAwsValue())
}
object DescribeGameSessionDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeGameSessionDetailsRequest =
      zio.aws.gamelift.model.DescribeGameSessionDetailsRequest(
        fleetId.map(value => value),
        gameSessionId.map(value => value),
        aliasId.map(value => value),
        location.map(value => value),
        statusFilter.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def fleetId: Optional[FleetIdOrArn]
    def gameSessionId: Optional[ArnStringModel]
    def aliasId: Optional[AliasIdOrArn]
    def location: Optional[LocationStringModel]
    def statusFilter: Optional[NonZeroAndMaxString]
    def limit: Optional[PositiveInteger]
    def nextToken: Optional[NonZeroAndMaxString]
    def getFleetId: ZIO[Any, AwsError, FleetIdOrArn] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getGameSessionId: ZIO[Any, AwsError, ArnStringModel] =
      AwsError.unwrapOptionField("gameSessionId", gameSessionId)
    def getAliasId: ZIO[Any, AwsError, AliasIdOrArn] =
      AwsError.unwrapOptionField("aliasId", aliasId)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
    def getStatusFilter: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("statusFilter", statusFilter)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest
  ) extends zio.aws.gamelift.model.DescribeGameSessionDetailsRequest.ReadOnly {
    override val fleetId: Optional[FleetIdOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetIdOrArn(value))
    override val gameSessionId: Optional[ArnStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.gameSessionId())
      .map(value => zio.aws.gamelift.model.primitives.ArnStringModel(value))
    override val aliasId: Optional[AliasIdOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.aliasId())
      .map(value => zio.aws.gamelift.model.primitives.AliasIdOrArn(value))
    override val location: Optional[LocationStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
    override val statusFilter: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusFilter())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val limit: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest
  ): zio.aws.gamelift.model.DescribeGameSessionDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
