package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class DescribeGameSessionDetailsResponse(
    gameSessionDetails: Optional[
      Iterable[zio.aws.gamelift.model.GameSessionDetail]
    ] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse = {
    import DescribeGameSessionDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse
      .builder()
      .optionallyWith(
        gameSessionDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameSessionDetails)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeGameSessionDetailsResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeGameSessionDetailsResponse
      .wrap(buildAwsValue())
}
object DescribeGameSessionDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeGameSessionDetailsResponse =
      zio.aws.gamelift.model.DescribeGameSessionDetailsResponse(
        gameSessionDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def gameSessionDetails
        : Optional[List[zio.aws.gamelift.model.GameSessionDetail.ReadOnly]]
    def nextToken: Optional[NonZeroAndMaxString]
    def getGameSessionDetails: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameSessionDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("gameSessionDetails", gameSessionDetails)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse
  ) extends zio.aws.gamelift.model.DescribeGameSessionDetailsResponse.ReadOnly {
    override val gameSessionDetails
        : Optional[List[zio.aws.gamelift.model.GameSessionDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.GameSessionDetail.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse
  ): zio.aws.gamelift.model.DescribeGameSessionDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
