package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeGameSessionPlacementResponse(
    gameSessionPlacement: Optional[
      zio.aws.gamelift.model.GameSessionPlacement
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementResponse = {
    import DescribeGameSessionPlacementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementResponse
      .builder()
      .optionallyWith(gameSessionPlacement.map(value => value.buildAwsValue()))(
        _.gameSessionPlacement
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeGameSessionPlacementResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeGameSessionPlacementResponse
      .wrap(buildAwsValue())
}
object DescribeGameSessionPlacementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DescribeGameSessionPlacementResponse =
      zio.aws.gamelift.model.DescribeGameSessionPlacementResponse(
        gameSessionPlacement.map(value => value.asEditable)
      )
    def gameSessionPlacement
        : Optional[zio.aws.gamelift.model.GameSessionPlacement.ReadOnly]
    def getGameSessionPlacement: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.GameSessionPlacement.ReadOnly
    ] = AwsError.unwrapOptionField("gameSessionPlacement", gameSessionPlacement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementResponse
  ) extends zio.aws.gamelift.model.DescribeGameSessionPlacementResponse.ReadOnly {
    override val gameSessionPlacement
        : Optional[zio.aws.gamelift.model.GameSessionPlacement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionPlacement())
        .map(value => zio.aws.gamelift.model.GameSessionPlacement.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementResponse
  ): zio.aws.gamelift.model.DescribeGameSessionPlacementResponse.ReadOnly =
    new Wrapper(impl)
}
