package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  PositiveInteger,
  GameSessionQueueNameOrArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeGameSessionQueuesRequest(
    names: Optional[Iterable[GameSessionQueueNameOrArn]] = Optional.Absent,
    limit: Optional[PositiveInteger] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest = {
    import DescribeGameSessionQueuesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest
      .builder()
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            GameSessionQueueNameOrArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeGameSessionQueuesRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeGameSessionQueuesRequest
      .wrap(buildAwsValue())
}
object DescribeGameSessionQueuesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeGameSessionQueuesRequest =
      zio.aws.gamelift.model.DescribeGameSessionQueuesRequest(
        names.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def names: Optional[List[GameSessionQueueNameOrArn]]
    def limit: Optional[PositiveInteger]
    def nextToken: Optional[NonZeroAndMaxString]
    def getNames: ZIO[Any, AwsError, List[GameSessionQueueNameOrArn]] =
      AwsError.unwrapOptionField("names", names)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest
  ) extends zio.aws.gamelift.model.DescribeGameSessionQueuesRequest.ReadOnly {
    override val names: Optional[List[GameSessionQueueNameOrArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.names())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.primitives.GameSessionQueueNameOrArn(item)
          }.toList
        )
    override val limit: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest
  ): zio.aws.gamelift.model.DescribeGameSessionQueuesRequest.ReadOnly =
    new Wrapper(impl)
}
