package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeMatchmakingResponse(
    ticketList: Optional[Iterable[zio.aws.gamelift.model.MatchmakingTicket]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingResponse = {
    import DescribeMatchmakingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingResponse
      .builder()
      .optionallyWith(
        ticketList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ticketList)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DescribeMatchmakingResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeMatchmakingResponse.wrap(buildAwsValue())
}
object DescribeMatchmakingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeMatchmakingResponse =
      zio.aws.gamelift.model.DescribeMatchmakingResponse(
        ticketList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def ticketList
        : Optional[List[zio.aws.gamelift.model.MatchmakingTicket.ReadOnly]]
    def getTicketList: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.MatchmakingTicket.ReadOnly
    ]] = AwsError.unwrapOptionField("ticketList", ticketList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingResponse
  ) extends zio.aws.gamelift.model.DescribeMatchmakingResponse.ReadOnly {
    override val ticketList
        : Optional[List[zio.aws.gamelift.model.MatchmakingTicket.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ticketList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.MatchmakingTicket.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingResponse
  ): zio.aws.gamelift.model.DescribeMatchmakingResponse.ReadOnly = new Wrapper(
    impl
  )
}
