package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.FleetIdOrArn
import scala.jdk.CollectionConverters._
final case class DescribeRuntimeConfigurationRequest(fleetId: FleetIdOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationRequest = {
    import DescribeRuntimeConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeRuntimeConfigurationRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeRuntimeConfigurationRequest
      .wrap(buildAwsValue())
}
object DescribeRuntimeConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeRuntimeConfigurationRequest =
      zio.aws.gamelift.model.DescribeRuntimeConfigurationRequest(fleetId)
    def fleetId: FleetIdOrArn
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationRequest
  ) extends zio.aws.gamelift.model.DescribeRuntimeConfigurationRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationRequest
  ): zio.aws.gamelift.model.DescribeRuntimeConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
