package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeRuntimeConfigurationResponse(
    runtimeConfiguration: Optional[
      zio.aws.gamelift.model.RuntimeConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationResponse = {
    import DescribeRuntimeConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationResponse
      .builder()
      .optionallyWith(runtimeConfiguration.map(value => value.buildAwsValue()))(
        _.runtimeConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeRuntimeConfigurationResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeRuntimeConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeRuntimeConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DescribeRuntimeConfigurationResponse =
      zio.aws.gamelift.model.DescribeRuntimeConfigurationResponse(
        runtimeConfiguration.map(value => value.asEditable)
      )
    def runtimeConfiguration
        : Optional[zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly]
    def getRuntimeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("runtimeConfiguration", runtimeConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationResponse
  ) extends zio.aws.gamelift.model.DescribeRuntimeConfigurationResponse.ReadOnly {
    override val runtimeConfiguration
        : Optional[zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeConfiguration())
        .map(value => zio.aws.gamelift.model.RuntimeConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationResponse
  ): zio.aws.gamelift.model.DescribeRuntimeConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
