package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.ScriptIdOrArn
import scala.jdk.CollectionConverters._
final case class DescribeScriptRequest(scriptId: ScriptIdOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeScriptRequest = {
    import DescribeScriptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeScriptRequest
      .builder()
      .scriptId(ScriptIdOrArn.unwrap(scriptId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DescribeScriptRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeScriptRequest.wrap(buildAwsValue())
}
object DescribeScriptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeScriptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeScriptRequest =
      zio.aws.gamelift.model.DescribeScriptRequest(scriptId)
    def scriptId: ScriptIdOrArn
    def getScriptId: ZIO[Any, Nothing, ScriptIdOrArn] = ZIO.succeed(scriptId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeScriptRequest
  ) extends zio.aws.gamelift.model.DescribeScriptRequest.ReadOnly {
    override val scriptId: ScriptIdOrArn =
      zio.aws.gamelift.model.primitives.ScriptIdOrArn(impl.scriptId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeScriptRequest
  ): zio.aws.gamelift.model.DescribeScriptRequest.ReadOnly = new Wrapper(impl)
}
