package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeScriptResponse(
    script: Optional[zio.aws.gamelift.model.Script] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeScriptResponse = {
    import DescribeScriptResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeScriptResponse
      .builder()
      .optionallyWith(script.map(value => value.buildAwsValue()))(_.script)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DescribeScriptResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeScriptResponse.wrap(buildAwsValue())
}
object DescribeScriptResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeScriptResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeScriptResponse =
      zio.aws.gamelift.model
        .DescribeScriptResponse(script.map(value => value.asEditable))
    def script: Optional[zio.aws.gamelift.model.Script.ReadOnly]
    def getScript: ZIO[Any, AwsError, zio.aws.gamelift.model.Script.ReadOnly] =
      AwsError.unwrapOptionField("script", script)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeScriptResponse
  ) extends zio.aws.gamelift.model.DescribeScriptResponse.ReadOnly {
    override val script: Optional[zio.aws.gamelift.model.Script.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.script())
        .map(value => zio.aws.gamelift.model.Script.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeScriptResponse
  ): zio.aws.gamelift.model.DescribeScriptResponse.ReadOnly = new Wrapper(impl)
}
