package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{PlayerData, NonZeroAndMaxString}
import scala.jdk.CollectionConverters._
final case class DesiredPlayerSession(
    playerId: Optional[NonZeroAndMaxString] = Optional.Absent,
    playerData: Optional[PlayerData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DesiredPlayerSession = {
    import DesiredPlayerSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DesiredPlayerSession
      .builder()
      .optionallyWith(
        playerId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.playerId)
      .optionallyWith(
        playerData.map(value => PlayerData.unwrap(value): java.lang.String)
      )(_.playerData)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DesiredPlayerSession.ReadOnly =
    zio.aws.gamelift.model.DesiredPlayerSession.wrap(buildAwsValue())
}
object DesiredPlayerSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DesiredPlayerSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DesiredPlayerSession =
      zio.aws.gamelift.model.DesiredPlayerSession(
        playerId.map(value => value),
        playerData.map(value => value)
      )
    def playerId: Optional[NonZeroAndMaxString]
    def playerData: Optional[PlayerData]
    def getPlayerId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("playerId", playerId)
    def getPlayerData: ZIO[Any, AwsError, PlayerData] =
      AwsError.unwrapOptionField("playerData", playerData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DesiredPlayerSession
  ) extends zio.aws.gamelift.model.DesiredPlayerSession.ReadOnly {
    override val playerId: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.playerId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val playerData: Optional[PlayerData] = zio.aws.core.internal
      .optionalFromNullable(impl.playerData())
      .map(value => zio.aws.gamelift.model.primitives.PlayerData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DesiredPlayerSession
  ): zio.aws.gamelift.model.DesiredPlayerSession.ReadOnly = new Wrapper(impl)
}
