package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait EventCode {
  def unwrap: software.amazon.awssdk.services.gamelift.model.EventCode
}
object EventCode {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.EventCode
  ): zio.aws.gamelift.model.EventCode = value match {
    case software.amazon.awssdk.services.gamelift.model.EventCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.GENERIC_EVENT =>
      val r = GENERIC_EVENT
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_CREATED =>
      val r = FLEET_CREATED
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_DELETED =>
      val r = FLEET_DELETED
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_SCALING_EVENT =>
      val r = FLEET_SCALING_EVENT
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_STATE_DOWNLOADING =>
      val r = FLEET_STATE_DOWNLOADING
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_STATE_VALIDATING =>
      val r = FLEET_STATE_VALIDATING
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_STATE_BUILDING =>
      val r = FLEET_STATE_BUILDING
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_STATE_ACTIVATING =>
      val r = FLEET_STATE_ACTIVATING
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_STATE_ACTIVE =>
      val r = FLEET_STATE_ACTIVE
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_STATE_ERROR =>
      val r = FLEET_STATE_ERROR
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_INITIALIZATION_FAILED =>
      val r = FLEET_INITIALIZATION_FAILED
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_BINARY_DOWNLOAD_FAILED =>
      val r = FLEET_BINARY_DOWNLOAD_FAILED
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND =>
      val r = FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE =>
      val r = FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_VALIDATION_TIMED_OUT =>
      val r = FLEET_VALIDATION_TIMED_OUT
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_ACTIVATION_FAILED =>
      val r = FLEET_ACTIVATION_FAILED
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_ACTIVATION_FAILED_NO_INSTANCES =>
      val r = FLEET_ACTIVATION_FAILED_NO_INSTANCES
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED =>
      val r = FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.SERVER_PROCESS_INVALID_PATH =>
      val r = SERVER_PROCESS_INVALID_PATH
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT =>
      val r = SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.SERVER_PROCESS_PROCESS_READY_TIMEOUT =>
      val r = SERVER_PROCESS_PROCESS_READY_TIMEOUT
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.SERVER_PROCESS_CRASHED =>
      val r = SERVER_PROCESS_CRASHED
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.SERVER_PROCESS_TERMINATED_UNHEALTHY =>
      val r = SERVER_PROCESS_TERMINATED_UNHEALTHY
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.SERVER_PROCESS_FORCE_TERMINATED =>
      val r = SERVER_PROCESS_FORCE_TERMINATED
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.SERVER_PROCESS_PROCESS_EXIT_TIMEOUT =>
      val r = SERVER_PROCESS_PROCESS_EXIT_TIMEOUT
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.GAME_SESSION_ACTIVATION_TIMEOUT =>
      val r = GAME_SESSION_ACTIVATION_TIMEOUT
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_CREATION_EXTRACTING_BUILD =>
      val r = FLEET_CREATION_EXTRACTING_BUILD
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_CREATION_RUNNING_INSTALLER =>
      val r = FLEET_CREATION_RUNNING_INSTALLER
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_CREATION_VALIDATING_RUNTIME_CONFIG =>
      val r = FLEET_CREATION_VALIDATING_RUNTIME_CONFIG
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_VPC_PEERING_SUCCEEDED =>
      val r = FLEET_VPC_PEERING_SUCCEEDED
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_VPC_PEERING_FAILED =>
      val r = FLEET_VPC_PEERING_FAILED
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_VPC_PEERING_DELETED =>
      val r = FLEET_VPC_PEERING_DELETED
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.INSTANCE_INTERRUPTED =>
      val r = INSTANCE_INTERRUPTED
      r
    case software.amazon.awssdk.services.gamelift.model.EventCode.INSTANCE_RECYCLED =>
      val r = INSTANCE_RECYCLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.UNKNOWN_TO_SDK_VERSION
  }
  case object GENERIC_EVENT extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.GENERIC_EVENT
  }
  case object FLEET_CREATED extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_CREATED
  }
  case object FLEET_DELETED extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_DELETED
  }
  case object FLEET_SCALING_EVENT extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_SCALING_EVENT
  }
  case object FLEET_STATE_DOWNLOADING extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_STATE_DOWNLOADING
  }
  case object FLEET_STATE_VALIDATING extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_STATE_VALIDATING
  }
  case object FLEET_STATE_BUILDING extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_STATE_BUILDING
  }
  case object FLEET_STATE_ACTIVATING extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_STATE_ACTIVATING
  }
  case object FLEET_STATE_ACTIVE extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_STATE_ACTIVE
  }
  case object FLEET_STATE_ERROR extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_STATE_ERROR
  }
  case object FLEET_INITIALIZATION_FAILED
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_INITIALIZATION_FAILED
  }
  case object FLEET_BINARY_DOWNLOAD_FAILED
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_BINARY_DOWNLOAD_FAILED
  }
  case object FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND
  }
  case object FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE
  }
  case object FLEET_VALIDATION_TIMED_OUT
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_VALIDATION_TIMED_OUT
  }
  case object FLEET_ACTIVATION_FAILED extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_ACTIVATION_FAILED
  }
  case object FLEET_ACTIVATION_FAILED_NO_INSTANCES
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_ACTIVATION_FAILED_NO_INSTANCES
  }
  case object FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED
  }
  case object SERVER_PROCESS_INVALID_PATH
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.SERVER_PROCESS_INVALID_PATH
  }
  case object SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.SERVER_PROCESS_SDK_INITIALIZATION_TIMEOUT
  }
  case object SERVER_PROCESS_PROCESS_READY_TIMEOUT
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.SERVER_PROCESS_PROCESS_READY_TIMEOUT
  }
  case object SERVER_PROCESS_CRASHED extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.SERVER_PROCESS_CRASHED
  }
  case object SERVER_PROCESS_TERMINATED_UNHEALTHY
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.SERVER_PROCESS_TERMINATED_UNHEALTHY
  }
  case object SERVER_PROCESS_FORCE_TERMINATED
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.SERVER_PROCESS_FORCE_TERMINATED
  }
  case object SERVER_PROCESS_PROCESS_EXIT_TIMEOUT
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.SERVER_PROCESS_PROCESS_EXIT_TIMEOUT
  }
  case object GAME_SESSION_ACTIVATION_TIMEOUT
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.GAME_SESSION_ACTIVATION_TIMEOUT
  }
  case object FLEET_CREATION_EXTRACTING_BUILD
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_CREATION_EXTRACTING_BUILD
  }
  case object FLEET_CREATION_RUNNING_INSTALLER
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_CREATION_RUNNING_INSTALLER
  }
  case object FLEET_CREATION_VALIDATING_RUNTIME_CONFIG
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_CREATION_VALIDATING_RUNTIME_CONFIG
  }
  case object FLEET_VPC_PEERING_SUCCEEDED
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_VPC_PEERING_SUCCEEDED
  }
  case object FLEET_VPC_PEERING_FAILED
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_VPC_PEERING_FAILED
  }
  case object FLEET_VPC_PEERING_DELETED
      extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.FLEET_VPC_PEERING_DELETED
  }
  case object INSTANCE_INTERRUPTED extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.INSTANCE_INTERRUPTED
  }
  case object INSTANCE_RECYCLED extends zio.aws.gamelift.model.EventCode {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.EventCode =
      software.amazon.awssdk.services.gamelift.model.EventCode.INSTANCE_RECYCLED
  }
}
