package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait GameServerClaimStatus {
  def unwrap
      : software.amazon.awssdk.services.gamelift.model.GameServerClaimStatus
}
object GameServerClaimStatus {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.GameServerClaimStatus
  ): zio.aws.gamelift.model.GameServerClaimStatus = value match {
    case software.amazon.awssdk.services.gamelift.model.GameServerClaimStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.GameServerClaimStatus.CLAIMED =>
      val r = CLAIMED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.GameServerClaimStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerClaimStatus =
      software.amazon.awssdk.services.gamelift.model.GameServerClaimStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CLAIMED extends zio.aws.gamelift.model.GameServerClaimStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameServerClaimStatus =
      software.amazon.awssdk.services.gamelift.model.GameServerClaimStatus.CLAIMED
  }
}
