package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  PositiveInteger,
  DnsName,
  IpAddress,
  ArnStringModel
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GameSessionConnectionInfo(
    gameSessionArn: Optional[ArnStringModel] = Optional.Absent,
    ipAddress: Optional[IpAddress] = Optional.Absent,
    dnsName: Optional[DnsName] = Optional.Absent,
    port: Optional[PositiveInteger] = Optional.Absent,
    matchedPlayerSessions: Optional[
      Iterable[zio.aws.gamelift.model.MatchedPlayerSession]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GameSessionConnectionInfo = {
    import GameSessionConnectionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GameSessionConnectionInfo
      .builder()
      .optionallyWith(
        gameSessionArn.map(value =>
          ArnStringModel.unwrap(value): java.lang.String
        )
      )(_.gameSessionArn)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        dnsName.map(value => DnsName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        port.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.port)
      .optionallyWith(
        matchedPlayerSessions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.matchedPlayerSessions)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GameSessionConnectionInfo.ReadOnly =
    zio.aws.gamelift.model.GameSessionConnectionInfo.wrap(buildAwsValue())
}
object GameSessionConnectionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GameSessionConnectionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GameSessionConnectionInfo =
      zio.aws.gamelift.model.GameSessionConnectionInfo(
        gameSessionArn.map(value => value),
        ipAddress.map(value => value),
        dnsName.map(value => value),
        port.map(value => value),
        matchedPlayerSessions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def gameSessionArn: Optional[ArnStringModel]
    def ipAddress: Optional[IpAddress]
    def dnsName: Optional[DnsName]
    def port: Optional[PositiveInteger]
    def matchedPlayerSessions
        : Optional[List[zio.aws.gamelift.model.MatchedPlayerSession.ReadOnly]]
    def getGameSessionArn: ZIO[Any, AwsError, ArnStringModel] =
      AwsError.unwrapOptionField("gameSessionArn", gameSessionArn)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getDnsName: ZIO[Any, AwsError, DnsName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getPort: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("port", port)
    def getMatchedPlayerSessions: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.MatchedPlayerSession.ReadOnly
    ]] =
      AwsError.unwrapOptionField("matchedPlayerSessions", matchedPlayerSessions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionConnectionInfo
  ) extends zio.aws.gamelift.model.GameSessionConnectionInfo.ReadOnly {
    override val gameSessionArn: Optional[ArnStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionArn())
        .map(value => zio.aws.gamelift.model.primitives.ArnStringModel(value))
    override val ipAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.gamelift.model.primitives.IpAddress(value))
    override val dnsName: Optional[DnsName] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => zio.aws.gamelift.model.primitives.DnsName(value))
    override val port: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val matchedPlayerSessions
        : Optional[List[zio.aws.gamelift.model.MatchedPlayerSession.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.matchedPlayerSessions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.MatchedPlayerSession.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GameSessionConnectionInfo
  ): zio.aws.gamelift.model.GameSessionConnectionInfo.ReadOnly = new Wrapper(
    impl
  )
}
