package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait GameSessionPlacementState {
  def unwrap
      : software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState
}
object GameSessionPlacementState {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState
  ): zio.aws.gamelift.model.GameSessionPlacementState = value match {
    case software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState.FULFILLED =>
      val r = FULFILLED
      r
    case software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState.TIMED_OUT =>
      val r = TIMED_OUT
      r
    case software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.GameSessionPlacementState {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState =
      software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.gamelift.model.GameSessionPlacementState {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState =
      software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState.PENDING
  }
  case object FULFILLED
      extends zio.aws.gamelift.model.GameSessionPlacementState {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState =
      software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState.FULFILLED
  }
  case object CANCELLED
      extends zio.aws.gamelift.model.GameSessionPlacementState {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState =
      software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState.CANCELLED
  }
  case object TIMED_OUT
      extends zio.aws.gamelift.model.GameSessionPlacementState {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState =
      software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState.TIMED_OUT
  }
  case object FAILED extends zio.aws.gamelift.model.GameSessionPlacementState {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState =
      software.amazon.awssdk.services.gamelift.model.GameSessionPlacementState.FAILED
  }
}
