package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait GameSessionStatusReason {
  def unwrap
      : software.amazon.awssdk.services.gamelift.model.GameSessionStatusReason
}
object GameSessionStatusReason {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.GameSessionStatusReason
  ): zio.aws.gamelift.model.GameSessionStatusReason = value match {
    case software.amazon.awssdk.services.gamelift.model.GameSessionStatusReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.GameSessionStatusReason.INTERRUPTED =>
      val r = INTERRUPTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.GameSessionStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameSessionStatusReason =
      software.amazon.awssdk.services.gamelift.model.GameSessionStatusReason.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERRUPTED
      extends zio.aws.gamelift.model.GameSessionStatusReason {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.GameSessionStatusReason =
      software.amazon.awssdk.services.gamelift.model.GameSessionStatusReason.INTERRUPTED
  }
}
