package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{
  ComputeArn,
  ComputeNameOrArn,
  FleetArn,
  FleetIdOrArn
}
import scala.jdk.CollectionConverters._
final case class GetComputeAccessResponse(
    fleetId: Optional[FleetIdOrArn] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent,
    computeName: Optional[ComputeNameOrArn] = Optional.Absent,
    computeArn: Optional[ComputeArn] = Optional.Absent,
    credentials: Optional[zio.aws.gamelift.model.Credentials] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GetComputeAccessResponse = {
    import GetComputeAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GetComputeAccessResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetIdOrArn.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        computeName.map(value =>
          ComputeNameOrArn.unwrap(value): java.lang.String
        )
      )(_.computeName)
      .optionallyWith(
        computeArn.map(value => ComputeArn.unwrap(value): java.lang.String)
      )(_.computeArn)
      .optionallyWith(credentials.map(value => value.buildAwsValue()))(
        _.credentials
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GetComputeAccessResponse.ReadOnly =
    zio.aws.gamelift.model.GetComputeAccessResponse.wrap(buildAwsValue())
}
object GetComputeAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GetComputeAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GetComputeAccessResponse =
      zio.aws.gamelift.model.GetComputeAccessResponse(
        fleetId.map(value => value),
        fleetArn.map(value => value),
        computeName.map(value => value),
        computeArn.map(value => value),
        credentials.map(value => value.asEditable)
      )
    def fleetId: Optional[FleetIdOrArn]
    def fleetArn: Optional[FleetArn]
    def computeName: Optional[ComputeNameOrArn]
    def computeArn: Optional[ComputeArn]
    def credentials: Optional[zio.aws.gamelift.model.Credentials.ReadOnly]
    def getFleetId: ZIO[Any, AwsError, FleetIdOrArn] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getComputeName: ZIO[Any, AwsError, ComputeNameOrArn] =
      AwsError.unwrapOptionField("computeName", computeName)
    def getComputeArn: ZIO[Any, AwsError, ComputeArn] =
      AwsError.unwrapOptionField("computeArn", computeArn)
    def getCredentials
        : ZIO[Any, AwsError, zio.aws.gamelift.model.Credentials.ReadOnly] =
      AwsError.unwrapOptionField("credentials", credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GetComputeAccessResponse
  ) extends zio.aws.gamelift.model.GetComputeAccessResponse.ReadOnly {
    override val fleetId: Optional[FleetIdOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetIdOrArn(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val computeName: Optional[ComputeNameOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.computeName())
      .map(value => zio.aws.gamelift.model.primitives.ComputeNameOrArn(value))
    override val computeArn: Optional[ComputeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.computeArn())
      .map(value => zio.aws.gamelift.model.primitives.ComputeArn(value))
    override val credentials
        : Optional[zio.aws.gamelift.model.Credentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentials())
        .map(value => zio.aws.gamelift.model.Credentials.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GetComputeAccessResponse
  ): zio.aws.gamelift.model.GetComputeAccessResponse.ReadOnly = new Wrapper(
    impl
  )
}
