package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.ArnStringModel
import scala.jdk.CollectionConverters._
final case class GetGameSessionLogUrlRequest(gameSessionId: ArnStringModel) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlRequest = {
    import GetGameSessionLogUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlRequest
      .builder()
      .gameSessionId(ArnStringModel.unwrap(gameSessionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.GetGameSessionLogUrlRequest.ReadOnly =
    zio.aws.gamelift.model.GetGameSessionLogUrlRequest.wrap(buildAwsValue())
}
object GetGameSessionLogUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.GetGameSessionLogUrlRequest =
      zio.aws.gamelift.model.GetGameSessionLogUrlRequest(gameSessionId)
    def gameSessionId: ArnStringModel
    def getGameSessionId: ZIO[Any, Nothing, ArnStringModel] =
      ZIO.succeed(gameSessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlRequest
  ) extends zio.aws.gamelift.model.GetGameSessionLogUrlRequest.ReadOnly {
    override val gameSessionId: ArnStringModel =
      zio.aws.gamelift.model.primitives.ArnStringModel(impl.gameSessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlRequest
  ): zio.aws.gamelift.model.GetGameSessionLogUrlRequest.ReadOnly = new Wrapper(
    impl
  )
}
