package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{PositiveInteger, NonEmptyString}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAliasesRequest(
    routingStrategyType: Optional[zio.aws.gamelift.model.RoutingStrategyType] =
      Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    limit: Optional[PositiveInteger] = Optional.Absent,
    nextToken: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListAliasesRequest = {
    import ListAliasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListAliasesRequest
      .builder()
      .optionallyWith(routingStrategyType.map(value => value.unwrap))(
        _.routingStrategyType
      )
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListAliasesRequest.ReadOnly =
    zio.aws.gamelift.model.ListAliasesRequest.wrap(buildAwsValue())
}
object ListAliasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListAliasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListAliasesRequest =
      zio.aws.gamelift.model.ListAliasesRequest(
        routingStrategyType.map(value => value),
        name.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def routingStrategyType
        : Optional[zio.aws.gamelift.model.RoutingStrategyType]
    def name: Optional[NonEmptyString]
    def limit: Optional[PositiveInteger]
    def nextToken: Optional[NonEmptyString]
    def getRoutingStrategyType
        : ZIO[Any, AwsError, zio.aws.gamelift.model.RoutingStrategyType] =
      AwsError.unwrapOptionField("routingStrategyType", routingStrategyType)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListAliasesRequest
  ) extends zio.aws.gamelift.model.ListAliasesRequest.ReadOnly {
    override val routingStrategyType
        : Optional[zio.aws.gamelift.model.RoutingStrategyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingStrategyType())
        .map(value => zio.aws.gamelift.model.RoutingStrategyType.wrap(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
    override val limit: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListAliasesRequest
  ): zio.aws.gamelift.model.ListAliasesRequest.ReadOnly = new Wrapper(impl)
}
