package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{NonZeroAndMaxString, PositiveInteger}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListGameServerGroupsRequest(
    limit: Optional[PositiveInteger] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest = {
    import ListGameServerGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest
      .builder()
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListGameServerGroupsRequest.ReadOnly =
    zio.aws.gamelift.model.ListGameServerGroupsRequest.wrap(buildAwsValue())
}
object ListGameServerGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListGameServerGroupsRequest =
      zio.aws.gamelift.model.ListGameServerGroupsRequest(
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def limit: Optional[PositiveInteger]
    def nextToken: Optional[NonZeroAndMaxString]
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest
  ) extends zio.aws.gamelift.model.ListGameServerGroupsRequest.ReadOnly {
    override val limit: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest
  ): zio.aws.gamelift.model.ListGameServerGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
