package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class ListLocationsResponse(
    locations: Optional[Iterable[zio.aws.gamelift.model.LocationModel]] =
      Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.ListLocationsResponse = {
    import ListLocationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.ListLocationsResponse
      .builder()
      .optionallyWith(
        locations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.locations)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.ListLocationsResponse.ReadOnly =
    zio.aws.gamelift.model.ListLocationsResponse.wrap(buildAwsValue())
}
object ListLocationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.ListLocationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.ListLocationsResponse =
      zio.aws.gamelift.model.ListLocationsResponse(
        locations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def locations: Optional[List[zio.aws.gamelift.model.LocationModel.ReadOnly]]
    def nextToken: Optional[NonZeroAndMaxString]
    def getLocations: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.LocationModel.ReadOnly
    ]] = AwsError.unwrapOptionField("locations", locations)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.ListLocationsResponse
  ) extends zio.aws.gamelift.model.ListLocationsResponse.ReadOnly {
    override val locations
        : Optional[List[zio.aws.gamelift.model.LocationModel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.LocationModel.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.ListLocationsResponse
  ): zio.aws.gamelift.model.ListLocationsResponse.ReadOnly = new Wrapper(impl)
}
