package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait LocationFilter {
  def unwrap: software.amazon.awssdk.services.gamelift.model.LocationFilter
}
object LocationFilter {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.LocationFilter
  ): zio.aws.gamelift.model.LocationFilter = value match {
    case software.amazon.awssdk.services.gamelift.model.LocationFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.LocationFilter.AWS =>
      val r = AWS
      r
    case software.amazon.awssdk.services.gamelift.model.LocationFilter.CUSTOM =>
      val r = CUSTOM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.LocationFilter {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.LocationFilter =
      software.amazon.awssdk.services.gamelift.model.LocationFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS extends zio.aws.gamelift.model.LocationFilter {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.LocationFilter =
      software.amazon.awssdk.services.gamelift.model.LocationFilter.AWS
  }
  case object CUSTOM extends zio.aws.gamelift.model.LocationFilter {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.LocationFilter =
      software.amazon.awssdk.services.gamelift.model.LocationFilter.CUSTOM
  }
}
