package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  PositiveInteger,
  NonEmptyString,
  NonZeroAndMaxString
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Player(
    playerId: Optional[NonZeroAndMaxString] = Optional.Absent,
    playerAttributes: Optional[
      Map[NonZeroAndMaxString, zio.aws.gamelift.model.AttributeValue]
    ] = Optional.Absent,
    team: Optional[NonZeroAndMaxString] = Optional.Absent,
    latencyInMs: Optional[Map[NonEmptyString, PositiveInteger]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.gamelift.model.Player = {
    import Player.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.Player
      .builder()
      .optionallyWith(
        playerId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.playerId)
      .optionallyWith(
        playerAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (NonZeroAndMaxString.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.playerAttributes)
      .optionallyWith(
        team.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.team)
      .optionallyWith(
        latencyInMs.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (PositiveInteger
                .unwrap(value): Integer)
            })
            .asJava
        )
      )(_.latencyInMs)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.Player.ReadOnly =
    zio.aws.gamelift.model.Player.wrap(buildAwsValue())
}
object Player {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.gamelift.model.Player] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.Player =
      zio.aws.gamelift.model.Player(
        playerId.map(value => value),
        playerAttributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        team.map(value => value),
        latencyInMs.map(value => value)
      )
    def playerId: Optional[NonZeroAndMaxString]
    def playerAttributes: Optional[
      Map[NonZeroAndMaxString, zio.aws.gamelift.model.AttributeValue.ReadOnly]
    ]
    def team: Optional[NonZeroAndMaxString]
    def latencyInMs: Optional[Map[NonEmptyString, PositiveInteger]]
    def getPlayerId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("playerId", playerId)
    def getPlayerAttributes: ZIO[Any, AwsError, Map[
      NonZeroAndMaxString,
      zio.aws.gamelift.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("playerAttributes", playerAttributes)
    def getTeam: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("team", team)
    def getLatencyInMs
        : ZIO[Any, AwsError, Map[NonEmptyString, PositiveInteger]] =
      AwsError.unwrapOptionField("latencyInMs", latencyInMs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.Player
  ) extends zio.aws.gamelift.model.Player.ReadOnly {
    override val playerId: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.playerId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val playerAttributes: Optional[
      Map[NonZeroAndMaxString, zio.aws.gamelift.model.AttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.playerAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.gamelift.model.primitives.NonZeroAndMaxString(
              key
            ) -> zio.aws.gamelift.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val team: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.team())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val latencyInMs: Optional[Map[NonEmptyString, PositiveInteger]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latencyInMs())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.gamelift.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.gamelift.model.primitives.PositiveInteger(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.Player
  ): zio.aws.gamelift.model.Player.ReadOnly = new Wrapper(impl)
}
