package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class PlayerLatency(
    playerId: Optional[NonZeroAndMaxString] = Optional.Absent,
    regionIdentifier: Optional[NonZeroAndMaxString] = Optional.Absent,
    latencyInMilliseconds: Optional[Float] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.PlayerLatency = {
    import PlayerLatency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.PlayerLatency
      .builder()
      .optionallyWith(
        playerId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.playerId)
      .optionallyWith(
        regionIdentifier.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.regionIdentifier)
      .optionallyWith(
        latencyInMilliseconds.map(value => value: java.lang.Float)
      )(_.latencyInMilliseconds)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.PlayerLatency.ReadOnly =
    zio.aws.gamelift.model.PlayerLatency.wrap(buildAwsValue())
}
object PlayerLatency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.PlayerLatency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.PlayerLatency =
      zio.aws.gamelift.model.PlayerLatency(
        playerId.map(value => value),
        regionIdentifier.map(value => value),
        latencyInMilliseconds.map(value => value)
      )
    def playerId: Optional[NonZeroAndMaxString]
    def regionIdentifier: Optional[NonZeroAndMaxString]
    def latencyInMilliseconds: Optional[Float]
    def getPlayerId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("playerId", playerId)
    def getRegionIdentifier: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("regionIdentifier", regionIdentifier)
    def getLatencyInMilliseconds: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("latencyInMilliseconds", latencyInMilliseconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.PlayerLatency
  ) extends zio.aws.gamelift.model.PlayerLatency.ReadOnly {
    override val playerId: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.playerId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val regionIdentifier: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regionIdentifier())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val latencyInMilliseconds: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.latencyInMilliseconds())
      .map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.PlayerLatency
  ): zio.aws.gamelift.model.PlayerLatency.ReadOnly = new Wrapper(impl)
}
