package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  DnsName,
  FleetId,
  PortNumber,
  FleetArn,
  Timestamp,
  IpAddress,
  PlayerData,
  PlayerSessionId,
  NonZeroAndMaxString
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PlayerSession(
    playerSessionId: Optional[PlayerSessionId] = Optional.Absent,
    playerId: Optional[NonZeroAndMaxString] = Optional.Absent,
    gameSessionId: Optional[NonZeroAndMaxString] = Optional.Absent,
    fleetId: Optional[FleetId] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    terminationTime: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.gamelift.model.PlayerSessionStatus] =
      Optional.Absent,
    ipAddress: Optional[IpAddress] = Optional.Absent,
    dnsName: Optional[DnsName] = Optional.Absent,
    port: Optional[PortNumber] = Optional.Absent,
    playerData: Optional[PlayerData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.PlayerSession = {
    import PlayerSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.PlayerSession
      .builder()
      .optionallyWith(
        playerSessionId.map(value =>
          PlayerSessionId.unwrap(value): java.lang.String
        )
      )(_.playerSessionId)
      .optionallyWith(
        playerId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.playerId)
      .optionallyWith(
        gameSessionId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.gameSessionId)
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        terminationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.terminationTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        dnsName.map(value => DnsName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(port.map(value => PortNumber.unwrap(value): Integer))(
        _.port
      )
      .optionallyWith(
        playerData.map(value => PlayerData.unwrap(value): java.lang.String)
      )(_.playerData)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.PlayerSession.ReadOnly =
    zio.aws.gamelift.model.PlayerSession.wrap(buildAwsValue())
}
object PlayerSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.PlayerSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.PlayerSession =
      zio.aws.gamelift.model.PlayerSession(
        playerSessionId.map(value => value),
        playerId.map(value => value),
        gameSessionId.map(value => value),
        fleetId.map(value => value),
        fleetArn.map(value => value),
        creationTime.map(value => value),
        terminationTime.map(value => value),
        status.map(value => value),
        ipAddress.map(value => value),
        dnsName.map(value => value),
        port.map(value => value),
        playerData.map(value => value)
      )
    def playerSessionId: Optional[PlayerSessionId]
    def playerId: Optional[NonZeroAndMaxString]
    def gameSessionId: Optional[NonZeroAndMaxString]
    def fleetId: Optional[FleetId]
    def fleetArn: Optional[FleetArn]
    def creationTime: Optional[Timestamp]
    def terminationTime: Optional[Timestamp]
    def status: Optional[zio.aws.gamelift.model.PlayerSessionStatus]
    def ipAddress: Optional[IpAddress]
    def dnsName: Optional[DnsName]
    def port: Optional[PortNumber]
    def playerData: Optional[PlayerData]
    def getPlayerSessionId: ZIO[Any, AwsError, PlayerSessionId] =
      AwsError.unwrapOptionField("playerSessionId", playerSessionId)
    def getPlayerId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("playerId", playerId)
    def getGameSessionId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("gameSessionId", gameSessionId)
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTerminationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("terminationTime", terminationTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.gamelift.model.PlayerSessionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getDnsName: ZIO[Any, AwsError, DnsName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getPort: ZIO[Any, AwsError, PortNumber] =
      AwsError.unwrapOptionField("port", port)
    def getPlayerData: ZIO[Any, AwsError, PlayerData] =
      AwsError.unwrapOptionField("playerData", playerData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.PlayerSession
  ) extends zio.aws.gamelift.model.PlayerSession.ReadOnly {
    override val playerSessionId: Optional[PlayerSessionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playerSessionId())
        .map(value => zio.aws.gamelift.model.primitives.PlayerSessionId(value))
    override val playerId: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.playerId())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val gameSessionId: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionId())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val terminationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.terminationTime())
      .map(value => zio.aws.gamelift.model.primitives.Timestamp(value))
    override val status: Optional[zio.aws.gamelift.model.PlayerSessionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.gamelift.model.PlayerSessionStatus.wrap(value))
    override val ipAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.gamelift.model.primitives.IpAddress(value))
    override val dnsName: Optional[DnsName] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => zio.aws.gamelift.model.primitives.DnsName(value))
    override val port: Optional[PortNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.gamelift.model.primitives.PortNumber(value))
    override val playerData: Optional[PlayerData] = zio.aws.core.internal
      .optionalFromNullable(impl.playerData())
      .map(value => zio.aws.gamelift.model.primitives.PlayerData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.PlayerSession
  ): zio.aws.gamelift.model.PlayerSession.ReadOnly = new Wrapper(impl)
}
