package zio.aws.gamelift.model
import scala.jdk.CollectionConverters._
sealed trait PlayerSessionStatus {
  def unwrap: software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus
}
object PlayerSessionStatus {
  def wrap(
      value: software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus
  ): zio.aws.gamelift.model.PlayerSessionStatus = value match {
    case software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus.RESERVED =>
      val r = RESERVED
      r
    case software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus.TIMEDOUT =>
      val r = TIMEDOUT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.gamelift.model.PlayerSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus =
      software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RESERVED extends zio.aws.gamelift.model.PlayerSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus =
      software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus.RESERVED
  }
  case object ACTIVE extends zio.aws.gamelift.model.PlayerSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus =
      software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus.ACTIVE
  }
  case object COMPLETED extends zio.aws.gamelift.model.PlayerSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus =
      software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus.COMPLETED
  }
  case object TIMEDOUT extends zio.aws.gamelift.model.PlayerSessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus =
      software.amazon.awssdk.services.gamelift.model.PlayerSessionStatus.TIMEDOUT
  }
}
