package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{
  FleetIdOrArn,
  LocationStringModel,
  IpAddress,
  ComputeName,
  DnsNameInput,
  NonZeroAndMaxString
}
import scala.jdk.CollectionConverters._
final case class RegisterComputeRequest(
    fleetId: FleetIdOrArn,
    computeName: ComputeName,
    certificatePath: Optional[NonZeroAndMaxString] = Optional.Absent,
    dnsName: Optional[DnsNameInput] = Optional.Absent,
    ipAddress: Optional[IpAddress] = Optional.Absent,
    location: Optional[LocationStringModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.RegisterComputeRequest = {
    import RegisterComputeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.RegisterComputeRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .computeName(ComputeName.unwrap(computeName): java.lang.String)
      .optionallyWith(
        certificatePath.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.certificatePath)
      .optionallyWith(
        dnsName.map(value => DnsNameInput.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.RegisterComputeRequest.ReadOnly =
    zio.aws.gamelift.model.RegisterComputeRequest.wrap(buildAwsValue())
}
object RegisterComputeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.RegisterComputeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.RegisterComputeRequest =
      zio.aws.gamelift.model.RegisterComputeRequest(
        fleetId,
        computeName,
        certificatePath.map(value => value),
        dnsName.map(value => value),
        ipAddress.map(value => value),
        location.map(value => value)
      )
    def fleetId: FleetIdOrArn
    def computeName: ComputeName
    def certificatePath: Optional[NonZeroAndMaxString]
    def dnsName: Optional[DnsNameInput]
    def ipAddress: Optional[IpAddress]
    def location: Optional[LocationStringModel]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getComputeName: ZIO[Any, Nothing, ComputeName] =
      ZIO.succeed(computeName)
    def getCertificatePath: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("certificatePath", certificatePath)
    def getDnsName: ZIO[Any, AwsError, DnsNameInput] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.RegisterComputeRequest
  ) extends zio.aws.gamelift.model.RegisterComputeRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val computeName: ComputeName =
      zio.aws.gamelift.model.primitives.ComputeName(impl.computeName())
    override val certificatePath: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificatePath())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val dnsName: Optional[DnsNameInput] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => zio.aws.gamelift.model.primitives.DnsNameInput(value))
    override val ipAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.gamelift.model.primitives.IpAddress(value))
    override val location: Optional[LocationStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.RegisterComputeRequest
  ): zio.aws.gamelift.model.RegisterComputeRequest.ReadOnly = new Wrapper(impl)
}
