package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterGameServerResponse(
    gameServer: Optional[zio.aws.gamelift.model.GameServer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.RegisterGameServerResponse = {
    import RegisterGameServerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.RegisterGameServerResponse
      .builder()
      .optionallyWith(gameServer.map(value => value.buildAwsValue()))(
        _.gameServer
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.RegisterGameServerResponse.ReadOnly =
    zio.aws.gamelift.model.RegisterGameServerResponse.wrap(buildAwsValue())
}
object RegisterGameServerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.RegisterGameServerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.RegisterGameServerResponse =
      zio.aws.gamelift.model
        .RegisterGameServerResponse(gameServer.map(value => value.asEditable))
    def gameServer: Optional[zio.aws.gamelift.model.GameServer.ReadOnly]
    def getGameServer
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServer.ReadOnly] =
      AwsError.unwrapOptionField("gameServer", gameServer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.RegisterGameServerResponse
  ) extends zio.aws.gamelift.model.RegisterGameServerResponse.ReadOnly {
    override val gameServer
        : Optional[zio.aws.gamelift.model.GameServer.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServer())
        .map(value => zio.aws.gamelift.model.GameServer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.RegisterGameServerResponse
  ): zio.aws.gamelift.model.RegisterGameServerResponse.ReadOnly = new Wrapper(
    impl
  )
}
