package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class S3Location(
    bucket: Optional[NonEmptyString] = Optional.Absent,
    key: Optional[NonEmptyString] = Optional.Absent,
    roleArn: Optional[NonEmptyString] = Optional.Absent,
    objectVersion: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.S3Location
      .builder()
      .optionallyWith(
        bucket.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        key.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        roleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        objectVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.objectVersion)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.S3Location.ReadOnly =
    zio.aws.gamelift.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.S3Location =
      zio.aws.gamelift.model.S3Location(
        bucket.map(value => value),
        key.map(value => value),
        roleArn.map(value => value),
        objectVersion.map(value => value)
      )
    def bucket: Optional[NonEmptyString]
    def key: Optional[NonEmptyString]
    def roleArn: Optional[NonEmptyString]
    def objectVersion: Optional[NonEmptyString]
    def getBucket: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("key", key)
    def getRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getObjectVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("objectVersion", objectVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.S3Location
  ) extends zio.aws.gamelift.model.S3Location.ReadOnly {
    override val bucket: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
    override val key: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
    override val roleArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
    override val objectVersion: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.objectVersion())
      .map(value => zio.aws.gamelift.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.S3Location
  ): zio.aws.gamelift.model.S3Location.ReadOnly = new Wrapper(impl)
}
