package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartMatchBackfillResponse(
    matchmakingTicket: Optional[zio.aws.gamelift.model.MatchmakingTicket] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.StartMatchBackfillResponse = {
    import StartMatchBackfillResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.StartMatchBackfillResponse
      .builder()
      .optionallyWith(matchmakingTicket.map(value => value.buildAwsValue()))(
        _.matchmakingTicket
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.StartMatchBackfillResponse.ReadOnly =
    zio.aws.gamelift.model.StartMatchBackfillResponse.wrap(buildAwsValue())
}
object StartMatchBackfillResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.StartMatchBackfillResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.StartMatchBackfillResponse =
      zio.aws.gamelift.model.StartMatchBackfillResponse(
        matchmakingTicket.map(value => value.asEditable)
      )
    def matchmakingTicket
        : Optional[zio.aws.gamelift.model.MatchmakingTicket.ReadOnly]
    def getMatchmakingTicket: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.MatchmakingTicket.ReadOnly
    ] = AwsError.unwrapOptionField("matchmakingTicket", matchmakingTicket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.StartMatchBackfillResponse
  ) extends zio.aws.gamelift.model.StartMatchBackfillResponse.ReadOnly {
    override val matchmakingTicket
        : Optional[zio.aws.gamelift.model.MatchmakingTicket.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.matchmakingTicket())
        .map(value => zio.aws.gamelift.model.MatchmakingTicket.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.StartMatchBackfillResponse
  ): zio.aws.gamelift.model.StartMatchBackfillResponse.ReadOnly = new Wrapper(
    impl
  )
}
