package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.AmazonResourceName
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceARN: AmazonResourceName,
    tags: Iterable[zio.aws.gamelift.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.TagResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.TagResourceRequest.ReadOnly =
    zio.aws.gamelift.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.TagResourceRequest =
      zio.aws.gamelift.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: AmazonResourceName
    def tags: List[zio.aws.gamelift.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getTags: ZIO[Any, Nothing, List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.TagResourceRequest
  ) extends zio.aws.gamelift.model.TagResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.gamelift.model.primitives.AmazonResourceName(impl.resourceARN())
    override val tags: List[zio.aws.gamelift.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.gamelift.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.TagResourceRequest
  ): zio.aws.gamelift.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
