package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  LocationStringModel,
  WholeNumber,
  FleetIdOrArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateFleetCapacityRequest(
    fleetId: FleetIdOrArn,
    desiredInstances: Optional[WholeNumber] = Optional.Absent,
    minSize: Optional[WholeNumber] = Optional.Absent,
    maxSize: Optional[WholeNumber] = Optional.Absent,
    location: Optional[LocationStringModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest = {
    import UpdateFleetCapacityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        desiredInstances.map(value => WholeNumber.unwrap(value): Integer)
      )(_.desiredInstances)
      .optionallyWith(minSize.map(value => WholeNumber.unwrap(value): Integer))(
        _.minSize
      )
      .optionallyWith(maxSize.map(value => WholeNumber.unwrap(value): Integer))(
        _.maxSize
      )
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateFleetCapacityRequest.ReadOnly =
    zio.aws.gamelift.model.UpdateFleetCapacityRequest.wrap(buildAwsValue())
}
object UpdateFleetCapacityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateFleetCapacityRequest =
      zio.aws.gamelift.model.UpdateFleetCapacityRequest(
        fleetId,
        desiredInstances.map(value => value),
        minSize.map(value => value),
        maxSize.map(value => value),
        location.map(value => value)
      )
    def fleetId: FleetIdOrArn
    def desiredInstances: Optional[WholeNumber]
    def minSize: Optional[WholeNumber]
    def maxSize: Optional[WholeNumber]
    def location: Optional[LocationStringModel]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getDesiredInstances: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("desiredInstances", desiredInstances)
    def getMinSize: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("minSize", minSize)
    def getMaxSize: ZIO[Any, AwsError, WholeNumber] =
      AwsError.unwrapOptionField("maxSize", maxSize)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest
  ) extends zio.aws.gamelift.model.UpdateFleetCapacityRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val desiredInstances: Optional[WholeNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredInstances())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val minSize: Optional[WholeNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.minSize())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val maxSize: Optional[WholeNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.maxSize())
      .map(value => zio.aws.gamelift.model.primitives.WholeNumber(value))
    override val location: Optional[LocationStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest
  ): zio.aws.gamelift.model.UpdateFleetCapacityRequest.ReadOnly = new Wrapper(
    impl
  )
}
