package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{FleetArn, FleetId}
import scala.jdk.CollectionConverters._
final case class UpdateFleetPortSettingsResponse(
    fleetId: Optional[FleetId] = Optional.Absent,
    fleetArn: Optional[FleetArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse = {
    import UpdateFleetPortSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        fleetArn.map(value => FleetArn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.UpdateFleetPortSettingsResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateFleetPortSettingsResponse.wrap(buildAwsValue())
}
object UpdateFleetPortSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateFleetPortSettingsResponse =
      zio.aws.gamelift.model.UpdateFleetPortSettingsResponse(
        fleetId.map(value => value),
        fleetArn.map(value => value)
      )
    def fleetId: Optional[FleetId]
    def fleetArn: Optional[FleetArn]
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getFleetArn: ZIO[Any, AwsError, FleetArn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse
  ) extends zio.aws.gamelift.model.UpdateFleetPortSettingsResponse.ReadOnly {
    override val fleetId: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetId(value))
    override val fleetArn: Optional[FleetArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.gamelift.model.primitives.FleetArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse
  ): zio.aws.gamelift.model.UpdateFleetPortSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
