package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateGameSessionResponse(
    gameSession: Optional[zio.aws.gamelift.model.GameSession] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse = {
    import UpdateGameSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse
      .builder()
      .optionallyWith(gameSession.map(value => value.buildAwsValue()))(
        _.gameSession
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.UpdateGameSessionResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateGameSessionResponse.wrap(buildAwsValue())
}
object UpdateGameSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateGameSessionResponse =
      zio.aws.gamelift.model
        .UpdateGameSessionResponse(gameSession.map(value => value.asEditable))
    def gameSession: Optional[zio.aws.gamelift.model.GameSession.ReadOnly]
    def getGameSession
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameSession.ReadOnly] =
      AwsError.unwrapOptionField("gameSession", gameSession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse
  ) extends zio.aws.gamelift.model.UpdateGameSessionResponse.ReadOnly {
    override val gameSession
        : Optional[zio.aws.gamelift.model.GameSession.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSession())
        .map(value => zio.aws.gamelift.model.GameSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse
  ): zio.aws.gamelift.model.UpdateGameSessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
