package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateRuntimeConfigurationResponse(
    runtimeConfiguration: Optional[
      zio.aws.gamelift.model.RuntimeConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationResponse = {
    import UpdateRuntimeConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationResponse
      .builder()
      .optionallyWith(runtimeConfiguration.map(value => value.buildAwsValue()))(
        _.runtimeConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.UpdateRuntimeConfigurationResponse.ReadOnly =
    zio.aws.gamelift.model.UpdateRuntimeConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateRuntimeConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.UpdateRuntimeConfigurationResponse =
      zio.aws.gamelift.model.UpdateRuntimeConfigurationResponse(
        runtimeConfiguration.map(value => value.asEditable)
      )
    def runtimeConfiguration
        : Optional[zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly]
    def getRuntimeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("runtimeConfiguration", runtimeConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationResponse
  ) extends zio.aws.gamelift.model.UpdateRuntimeConfigurationResponse.ReadOnly {
    override val runtimeConfiguration
        : Optional[zio.aws.gamelift.model.RuntimeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeConfiguration())
        .map(value => zio.aws.gamelift.model.RuntimeConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationResponse
  ): zio.aws.gamelift.model.UpdateRuntimeConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
