package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  NonBlankAndLengthConstraintString
}
import scala.jdk.CollectionConverters._
final case class CreateAliasRequest(
    name: NonBlankAndLengthConstraintString,
    description: Optional[NonZeroAndMaxString] = Optional.Absent,
    routingStrategy: zio.aws.gamelift.model.RoutingStrategy,
    tags: Optional[Iterable[zio.aws.gamelift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateAliasRequest = {
    import CreateAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateAliasRequest
      .builder()
      .name(NonBlankAndLengthConstraintString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.description)
      .routingStrategy(routingStrategy.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateAliasRequest.ReadOnly =
    zio.aws.gamelift.model.CreateAliasRequest.wrap(buildAwsValue())
}
object CreateAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateAliasRequest =
      zio.aws.gamelift.model.CreateAliasRequest(
        name,
        description.map(value => value),
        routingStrategy.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: NonBlankAndLengthConstraintString
    def description: Optional[NonZeroAndMaxString]
    def routingStrategy: zio.aws.gamelift.model.RoutingStrategy.ReadOnly
    def tags: Optional[List[zio.aws.gamelift.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, NonBlankAndLengthConstraintString] =
      ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("description", description)
    def getRoutingStrategy
        : ZIO[Any, Nothing, zio.aws.gamelift.model.RoutingStrategy.ReadOnly] =
      ZIO.succeed(routingStrategy)
    def getTags: ZIO[Any, AwsError, List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateAliasRequest
  ) extends zio.aws.gamelift.model.CreateAliasRequest.ReadOnly {
    override val name: NonBlankAndLengthConstraintString =
      zio.aws.gamelift.model.primitives
        .NonBlankAndLengthConstraintString(impl.name())
    override val description: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val routingStrategy
        : zio.aws.gamelift.model.RoutingStrategy.ReadOnly =
      zio.aws.gamelift.model.RoutingStrategy.wrap(impl.routingStrategy())
    override val tags: Optional[List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateAliasRequest
  ): zio.aws.gamelift.model.CreateAliasRequest.ReadOnly = new Wrapper(impl)
}
