package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBuildResponse(
    build: Optional[zio.aws.gamelift.model.Build] = Optional.Absent,
    uploadCredentials: Optional[zio.aws.gamelift.model.Credentials] =
      Optional.Absent,
    storageLocation: Optional[zio.aws.gamelift.model.S3Location] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateBuildResponse = {
    import CreateBuildResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateBuildResponse
      .builder()
      .optionallyWith(build.map(value => value.buildAwsValue()))(_.build)
      .optionallyWith(uploadCredentials.map(value => value.buildAwsValue()))(
        _.uploadCredentials
      )
      .optionallyWith(storageLocation.map(value => value.buildAwsValue()))(
        _.storageLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateBuildResponse.ReadOnly =
    zio.aws.gamelift.model.CreateBuildResponse.wrap(buildAwsValue())
}
object CreateBuildResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateBuildResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateBuildResponse =
      zio.aws.gamelift.model.CreateBuildResponse(
        build.map(value => value.asEditable),
        uploadCredentials.map(value => value.asEditable),
        storageLocation.map(value => value.asEditable)
      )
    def build: Optional[zio.aws.gamelift.model.Build.ReadOnly]
    def uploadCredentials: Optional[zio.aws.gamelift.model.Credentials.ReadOnly]
    def storageLocation: Optional[zio.aws.gamelift.model.S3Location.ReadOnly]
    def getBuild: ZIO[Any, AwsError, zio.aws.gamelift.model.Build.ReadOnly] =
      AwsError.unwrapOptionField("build", build)
    def getUploadCredentials
        : ZIO[Any, AwsError, zio.aws.gamelift.model.Credentials.ReadOnly] =
      AwsError.unwrapOptionField("uploadCredentials", uploadCredentials)
    def getStorageLocation
        : ZIO[Any, AwsError, zio.aws.gamelift.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("storageLocation", storageLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateBuildResponse
  ) extends zio.aws.gamelift.model.CreateBuildResponse.ReadOnly {
    override val build: Optional[zio.aws.gamelift.model.Build.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.build())
        .map(value => zio.aws.gamelift.model.Build.wrap(value))
    override val uploadCredentials
        : Optional[zio.aws.gamelift.model.Credentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uploadCredentials())
        .map(value => zio.aws.gamelift.model.Credentials.wrap(value))
    override val storageLocation
        : Optional[zio.aws.gamelift.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageLocation())
        .map(value => zio.aws.gamelift.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateBuildResponse
  ): zio.aws.gamelift.model.CreateBuildResponse.ReadOnly = new Wrapper(impl)
}
