package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateGameServerGroupResponse(
    gameServerGroup: Optional[zio.aws.gamelift.model.GameServerGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupResponse = {
    import CreateGameServerGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupResponse
      .builder()
      .optionallyWith(gameServerGroup.map(value => value.buildAwsValue()))(
        _.gameServerGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.CreateGameServerGroupResponse.ReadOnly =
    zio.aws.gamelift.model.CreateGameServerGroupResponse.wrap(buildAwsValue())
}
object CreateGameServerGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateGameServerGroupResponse =
      zio.aws.gamelift.model.CreateGameServerGroupResponse(
        gameServerGroup.map(value => value.asEditable)
      )
    def gameServerGroup
        : Optional[zio.aws.gamelift.model.GameServerGroup.ReadOnly]
    def getGameServerGroup
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServerGroup.ReadOnly] =
      AwsError.unwrapOptionField("gameServerGroup", gameServerGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupResponse
  ) extends zio.aws.gamelift.model.CreateGameServerGroupResponse.ReadOnly {
    override val gameServerGroup
        : Optional[zio.aws.gamelift.model.GameServerGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServerGroup())
        .map(value => zio.aws.gamelift.model.GameServerGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupResponse
  ): zio.aws.gamelift.model.CreateGameServerGroupResponse.ReadOnly =
    new Wrapper(impl)
}
