package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateGameSessionQueueResponse(
    gameSessionQueue: Optional[zio.aws.gamelift.model.GameSessionQueue] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueResponse = {
    import CreateGameSessionQueueResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueResponse
      .builder()
      .optionallyWith(gameSessionQueue.map(value => value.buildAwsValue()))(
        _.gameSessionQueue
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.CreateGameSessionQueueResponse.ReadOnly =
    zio.aws.gamelift.model.CreateGameSessionQueueResponse.wrap(buildAwsValue())
}
object CreateGameSessionQueueResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateGameSessionQueueResponse =
      zio.aws.gamelift.model.CreateGameSessionQueueResponse(
        gameSessionQueue.map(value => value.asEditable)
      )
    def gameSessionQueue
        : Optional[zio.aws.gamelift.model.GameSessionQueue.ReadOnly]
    def getGameSessionQueue
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameSessionQueue.ReadOnly] =
      AwsError.unwrapOptionField("gameSessionQueue", gameSessionQueue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueResponse
  ) extends zio.aws.gamelift.model.CreateGameSessionQueueResponse.ReadOnly {
    override val gameSessionQueue
        : Optional[zio.aws.gamelift.model.GameSessionQueue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionQueue())
        .map(value => zio.aws.gamelift.model.GameSessionQueue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueResponse
  ): zio.aws.gamelift.model.CreateGameSessionQueueResponse.ReadOnly =
    new Wrapper(impl)
}
