package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  FleetIdOrArn,
  WholeNumber,
  LocationStringModel,
  IdStringModel,
  LargeGameSessionData,
  NonZeroAndMaxString,
  AliasIdOrArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateGameSessionRequest(
    fleetId: Optional[FleetIdOrArn] = Optional.Absent,
    aliasId: Optional[AliasIdOrArn] = Optional.Absent,
    maximumPlayerSessionCount: WholeNumber,
    name: Optional[NonZeroAndMaxString] = Optional.Absent,
    gameProperties: Optional[Iterable[zio.aws.gamelift.model.GameProperty]] =
      Optional.Absent,
    creatorId: Optional[NonZeroAndMaxString] = Optional.Absent,
    gameSessionId: Optional[IdStringModel] = Optional.Absent,
    idempotencyToken: Optional[IdStringModel] = Optional.Absent,
    gameSessionData: Optional[LargeGameSessionData] = Optional.Absent,
    location: Optional[LocationStringModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest = {
    import CreateGameSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest
      .builder()
      .optionallyWith(
        fleetId.map(value => FleetIdOrArn.unwrap(value): java.lang.String)
      )(_.fleetId)
      .optionallyWith(
        aliasId.map(value => AliasIdOrArn.unwrap(value): java.lang.String)
      )(_.aliasId)
      .maximumPlayerSessionCount(
        WholeNumber.unwrap(maximumPlayerSessionCount): Integer
      )
      .optionallyWith(
        name.map(value => NonZeroAndMaxString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        gameProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameProperties)
      .optionallyWith(
        creatorId.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.creatorId)
      .optionallyWith(
        gameSessionId.map(value =>
          IdStringModel.unwrap(value): java.lang.String
        )
      )(_.gameSessionId)
      .optionallyWith(
        idempotencyToken.map(value =>
          IdStringModel.unwrap(value): java.lang.String
        )
      )(_.idempotencyToken)
      .optionallyWith(
        gameSessionData.map(value =>
          LargeGameSessionData.unwrap(value): java.lang.String
        )
      )(_.gameSessionData)
      .optionallyWith(
        location.map(value =>
          LocationStringModel.unwrap(value): java.lang.String
        )
      )(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateGameSessionRequest.ReadOnly =
    zio.aws.gamelift.model.CreateGameSessionRequest.wrap(buildAwsValue())
}
object CreateGameSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateGameSessionRequest =
      zio.aws.gamelift.model.CreateGameSessionRequest(
        fleetId.map(value => value),
        aliasId.map(value => value),
        maximumPlayerSessionCount,
        name.map(value => value),
        gameProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creatorId.map(value => value),
        gameSessionId.map(value => value),
        idempotencyToken.map(value => value),
        gameSessionData.map(value => value),
        location.map(value => value)
      )
    def fleetId: Optional[FleetIdOrArn]
    def aliasId: Optional[AliasIdOrArn]
    def maximumPlayerSessionCount: WholeNumber
    def name: Optional[NonZeroAndMaxString]
    def gameProperties
        : Optional[List[zio.aws.gamelift.model.GameProperty.ReadOnly]]
    def creatorId: Optional[NonZeroAndMaxString]
    def gameSessionId: Optional[IdStringModel]
    def idempotencyToken: Optional[IdStringModel]
    def gameSessionData: Optional[LargeGameSessionData]
    def location: Optional[LocationStringModel]
    def getFleetId: ZIO[Any, AwsError, FleetIdOrArn] =
      AwsError.unwrapOptionField("fleetId", fleetId)
    def getAliasId: ZIO[Any, AwsError, AliasIdOrArn] =
      AwsError.unwrapOptionField("aliasId", aliasId)
    def getMaximumPlayerSessionCount: ZIO[Any, Nothing, WholeNumber] =
      ZIO.succeed(maximumPlayerSessionCount)
    def getName: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("name", name)
    def getGameProperties: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("gameProperties", gameProperties)
    def getCreatorId: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("creatorId", creatorId)
    def getGameSessionId: ZIO[Any, AwsError, IdStringModel] =
      AwsError.unwrapOptionField("gameSessionId", gameSessionId)
    def getIdempotencyToken: ZIO[Any, AwsError, IdStringModel] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getGameSessionData: ZIO[Any, AwsError, LargeGameSessionData] =
      AwsError.unwrapOptionField("gameSessionData", gameSessionData)
    def getLocation: ZIO[Any, AwsError, LocationStringModel] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest
  ) extends zio.aws.gamelift.model.CreateGameSessionRequest.ReadOnly {
    override val fleetId: Optional[FleetIdOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetId())
      .map(value => zio.aws.gamelift.model.primitives.FleetIdOrArn(value))
    override val aliasId: Optional[AliasIdOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.aliasId())
      .map(value => zio.aws.gamelift.model.primitives.AliasIdOrArn(value))
    override val maximumPlayerSessionCount: WholeNumber =
      zio.aws.gamelift.model.primitives
        .WholeNumber(impl.maximumPlayerSessionCount())
    override val name: Optional[NonZeroAndMaxString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
      )
    override val gameProperties
        : Optional[List[zio.aws.gamelift.model.GameProperty.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.GameProperty.wrap(item)
          }.toList
        )
    override val creatorId: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creatorId())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
    override val gameSessionId: Optional[IdStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.gameSessionId())
      .map(value => zio.aws.gamelift.model.primitives.IdStringModel(value))
    override val idempotencyToken: Optional[IdStringModel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idempotencyToken())
        .map(value => zio.aws.gamelift.model.primitives.IdStringModel(value))
    override val gameSessionData: Optional[LargeGameSessionData] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameSessionData())
        .map(value =>
          zio.aws.gamelift.model.primitives.LargeGameSessionData(value)
        )
    override val location: Optional[LocationStringModel] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.gamelift.model.primitives.LocationStringModel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest
  ): zio.aws.gamelift.model.CreateGameSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
