package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.CustomInputLocationStringModel
import scala.jdk.CollectionConverters._
final case class CreateLocationRequest(
    locationName: CustomInputLocationStringModel,
    tags: Optional[Iterable[zio.aws.gamelift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateLocationRequest = {
    import CreateLocationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateLocationRequest
      .builder()
      .locationName(
        CustomInputLocationStringModel.unwrap(locationName): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateLocationRequest.ReadOnly =
    zio.aws.gamelift.model.CreateLocationRequest.wrap(buildAwsValue())
}
object CreateLocationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateLocationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateLocationRequest =
      zio.aws.gamelift.model.CreateLocationRequest(
        locationName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def locationName: CustomInputLocationStringModel
    def tags: Optional[List[zio.aws.gamelift.model.Tag.ReadOnly]]
    def getLocationName: ZIO[Any, Nothing, CustomInputLocationStringModel] =
      ZIO.succeed(locationName)
    def getTags: ZIO[Any, AwsError, List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateLocationRequest
  ) extends zio.aws.gamelift.model.CreateLocationRequest.ReadOnly {
    override val locationName: CustomInputLocationStringModel =
      zio.aws.gamelift.model.primitives
        .CustomInputLocationStringModel(impl.locationName())
    override val tags: Optional[List[zio.aws.gamelift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateLocationRequest
  ): zio.aws.gamelift.model.CreateLocationRequest.ReadOnly = new Wrapper(impl)
}
