package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLocationResponse(
    location: Optional[zio.aws.gamelift.model.LocationModel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateLocationResponse = {
    import CreateLocationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateLocationResponse
      .builder()
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreateLocationResponse.ReadOnly =
    zio.aws.gamelift.model.CreateLocationResponse.wrap(buildAwsValue())
}
object CreateLocationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateLocationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreateLocationResponse =
      zio.aws.gamelift.model
        .CreateLocationResponse(location.map(value => value.asEditable))
    def location: Optional[zio.aws.gamelift.model.LocationModel.ReadOnly]
    def getLocation
        : ZIO[Any, AwsError, zio.aws.gamelift.model.LocationModel.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateLocationResponse
  ) extends zio.aws.gamelift.model.CreateLocationResponse.ReadOnly {
    override val location
        : Optional[zio.aws.gamelift.model.LocationModel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.gamelift.model.LocationModel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateLocationResponse
  ): zio.aws.gamelift.model.CreateLocationResponse.ReadOnly = new Wrapper(impl)
}
