package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePlayerSessionResponse(
    playerSession: Optional[zio.aws.gamelift.model.PlayerSession] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionResponse = {
    import CreatePlayerSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionResponse
      .builder()
      .optionallyWith(playerSession.map(value => value.buildAwsValue()))(
        _.playerSession
      )
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.CreatePlayerSessionResponse.ReadOnly =
    zio.aws.gamelift.model.CreatePlayerSessionResponse.wrap(buildAwsValue())
}
object CreatePlayerSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.CreatePlayerSessionResponse =
      zio.aws.gamelift.model.CreatePlayerSessionResponse(
        playerSession.map(value => value.asEditable)
      )
    def playerSession: Optional[zio.aws.gamelift.model.PlayerSession.ReadOnly]
    def getPlayerSession
        : ZIO[Any, AwsError, zio.aws.gamelift.model.PlayerSession.ReadOnly] =
      AwsError.unwrapOptionField("playerSession", playerSession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionResponse
  ) extends zio.aws.gamelift.model.CreatePlayerSessionResponse.ReadOnly {
    override val playerSession
        : Optional[zio.aws.gamelift.model.PlayerSession.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.playerSession())
        .map(value => zio.aws.gamelift.model.PlayerSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionResponse
  ): zio.aws.gamelift.model.CreatePlayerSessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
