package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class CreateVpcPeeringAuthorizationRequest(
    gameLiftAwsAccountId: NonZeroAndMaxString,
    peerVpcId: NonZeroAndMaxString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationRequest = {
    import CreateVpcPeeringAuthorizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationRequest
      .builder()
      .gameLiftAwsAccountId(
        NonZeroAndMaxString.unwrap(gameLiftAwsAccountId): java.lang.String
      )
      .peerVpcId(NonZeroAndMaxString.unwrap(peerVpcId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.CreateVpcPeeringAuthorizationRequest.ReadOnly =
    zio.aws.gamelift.model.CreateVpcPeeringAuthorizationRequest
      .wrap(buildAwsValue())
}
object CreateVpcPeeringAuthorizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.CreateVpcPeeringAuthorizationRequest =
      zio.aws.gamelift.model
        .CreateVpcPeeringAuthorizationRequest(gameLiftAwsAccountId, peerVpcId)
    def gameLiftAwsAccountId: NonZeroAndMaxString
    def peerVpcId: NonZeroAndMaxString
    def getGameLiftAwsAccountId: ZIO[Any, Nothing, NonZeroAndMaxString] =
      ZIO.succeed(gameLiftAwsAccountId)
    def getPeerVpcId: ZIO[Any, Nothing, NonZeroAndMaxString] =
      ZIO.succeed(peerVpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationRequest
  ) extends zio.aws.gamelift.model.CreateVpcPeeringAuthorizationRequest.ReadOnly {
    override val gameLiftAwsAccountId: NonZeroAndMaxString =
      zio.aws.gamelift.model.primitives
        .NonZeroAndMaxString(impl.gameLiftAwsAccountId())
    override val peerVpcId: NonZeroAndMaxString =
      zio.aws.gamelift.model.primitives.NonZeroAndMaxString(impl.peerVpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationRequest
  ): zio.aws.gamelift.model.CreateVpcPeeringAuthorizationRequest.ReadOnly =
    new Wrapper(impl)
}
