package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteGameServerGroupResponse(
    gameServerGroup: Optional[zio.aws.gamelift.model.GameServerGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupResponse = {
    import DeleteGameServerGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupResponse
      .builder()
      .optionallyWith(gameServerGroup.map(value => value.buildAwsValue()))(
        _.gameServerGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DeleteGameServerGroupResponse.ReadOnly =
    zio.aws.gamelift.model.DeleteGameServerGroupResponse.wrap(buildAwsValue())
}
object DeleteGameServerGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DeleteGameServerGroupResponse =
      zio.aws.gamelift.model.DeleteGameServerGroupResponse(
        gameServerGroup.map(value => value.asEditable)
      )
    def gameServerGroup
        : Optional[zio.aws.gamelift.model.GameServerGroup.ReadOnly]
    def getGameServerGroup
        : ZIO[Any, AwsError, zio.aws.gamelift.model.GameServerGroup.ReadOnly] =
      AwsError.unwrapOptionField("gameServerGroup", gameServerGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupResponse
  ) extends zio.aws.gamelift.model.DeleteGameServerGroupResponse.ReadOnly {
    override val gameServerGroup
        : Optional[zio.aws.gamelift.model.GameServerGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServerGroup())
        .map(value => zio.aws.gamelift.model.GameServerGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupResponse
  ): zio.aws.gamelift.model.DeleteGameServerGroupResponse.ReadOnly =
    new Wrapper(impl)
}
