package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.BuildIdOrArn
import scala.jdk.CollectionConverters._
final case class DescribeBuildRequest(buildId: BuildIdOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeBuildRequest = {
    import DescribeBuildRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeBuildRequest
      .builder()
      .buildId(BuildIdOrArn.unwrap(buildId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.gamelift.model.DescribeBuildRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeBuildRequest.wrap(buildAwsValue())
}
object DescribeBuildRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeBuildRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeBuildRequest =
      zio.aws.gamelift.model.DescribeBuildRequest(buildId)
    def buildId: BuildIdOrArn
    def getBuildId: ZIO[Any, Nothing, BuildIdOrArn] = ZIO.succeed(buildId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeBuildRequest
  ) extends zio.aws.gamelift.model.DescribeBuildRequest.ReadOnly {
    override val buildId: BuildIdOrArn =
      zio.aws.gamelift.model.primitives.BuildIdOrArn(impl.buildId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeBuildRequest
  ): zio.aws.gamelift.model.DescribeBuildRequest.ReadOnly = new Wrapper(impl)
}
