package zio.aws.gamelift.model
import zio.aws.gamelift.model.primitives.{
  NonZeroAndMaxString,
  PositiveInteger,
  LocationStringModel,
  FleetIdOrArn
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeFleetLocationAttributesRequest(
    fleetId: FleetIdOrArn,
    locations: Optional[Iterable[LocationStringModel]] = Optional.Absent,
    limit: Optional[PositiveInteger] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest = {
    import DescribeFleetLocationAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest
      .builder()
      .fleetId(FleetIdOrArn.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        locations.map(value =>
          value.map { item =>
            LocationStringModel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.locations)
      .optionallyWith(
        limit.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest
      .wrap(buildAwsValue())
}
object DescribeFleetLocationAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest =
      zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest(
        fleetId,
        locations.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def fleetId: FleetIdOrArn
    def locations: Optional[List[LocationStringModel]]
    def limit: Optional[PositiveInteger]
    def nextToken: Optional[NonZeroAndMaxString]
    def getFleetId: ZIO[Any, Nothing, FleetIdOrArn] = ZIO.succeed(fleetId)
    def getLocations: ZIO[Any, AwsError, List[LocationStringModel]] =
      AwsError.unwrapOptionField("locations", locations)
    def getLimit: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest
  ) extends zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest.ReadOnly {
    override val fleetId: FleetIdOrArn =
      zio.aws.gamelift.model.primitives.FleetIdOrArn(impl.fleetId())
    override val locations: Optional[List[LocationStringModel]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.primitives.LocationStringModel(item)
          }.toList
        )
    override val limit: Optional[PositiveInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.gamelift.model.primitives.PositiveInteger(value))
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest
  ): zio.aws.gamelift.model.DescribeFleetLocationAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
