package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeFleetLocationCapacityResponse(
    fleetCapacity: Optional[zio.aws.gamelift.model.FleetCapacity] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationCapacityResponse = {
    import DescribeFleetLocationCapacityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationCapacityResponse
      .builder()
      .optionallyWith(fleetCapacity.map(value => value.buildAwsValue()))(
        _.fleetCapacity
      )
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeFleetLocationCapacityResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeFleetLocationCapacityResponse
      .wrap(buildAwsValue())
}
object DescribeFleetLocationCapacityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationCapacityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.gamelift.model.DescribeFleetLocationCapacityResponse =
      zio.aws.gamelift.model.DescribeFleetLocationCapacityResponse(
        fleetCapacity.map(value => value.asEditable)
      )
    def fleetCapacity: Optional[zio.aws.gamelift.model.FleetCapacity.ReadOnly]
    def getFleetCapacity
        : ZIO[Any, AwsError, zio.aws.gamelift.model.FleetCapacity.ReadOnly] =
      AwsError.unwrapOptionField("fleetCapacity", fleetCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationCapacityResponse
  ) extends zio.aws.gamelift.model.DescribeFleetLocationCapacityResponse.ReadOnly {
    override val fleetCapacity
        : Optional[zio.aws.gamelift.model.FleetCapacity.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetCapacity())
        .map(value => zio.aws.gamelift.model.FleetCapacity.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationCapacityResponse
  ): zio.aws.gamelift.model.DescribeFleetLocationCapacityResponse.ReadOnly =
    new Wrapper(impl)
}
