package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.gamelift.model.primitives.NonZeroAndMaxString
import scala.jdk.CollectionConverters._
final case class DescribeGameServerInstancesResponse(
    gameServerInstances: Optional[
      Iterable[zio.aws.gamelift.model.GameServerInstance]
    ] = Optional.Absent,
    nextToken: Optional[NonZeroAndMaxString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse = {
    import DescribeGameServerInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse
      .builder()
      .optionallyWith(
        gameServerInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.gameServerInstances)
      .optionallyWith(
        nextToken.map(value =>
          NonZeroAndMaxString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeGameServerInstancesResponse.ReadOnly =
    zio.aws.gamelift.model.DescribeGameServerInstancesResponse
      .wrap(buildAwsValue())
}
object DescribeGameServerInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeGameServerInstancesResponse =
      zio.aws.gamelift.model.DescribeGameServerInstancesResponse(
        gameServerInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def gameServerInstances
        : Optional[List[zio.aws.gamelift.model.GameServerInstance.ReadOnly]]
    def nextToken: Optional[NonZeroAndMaxString]
    def getGameServerInstances: ZIO[Any, AwsError, List[
      zio.aws.gamelift.model.GameServerInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("gameServerInstances", gameServerInstances)
    def getNextToken: ZIO[Any, AwsError, NonZeroAndMaxString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse
  ) extends zio.aws.gamelift.model.DescribeGameServerInstancesResponse.ReadOnly {
    override val gameServerInstances
        : Optional[List[zio.aws.gamelift.model.GameServerInstance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gameServerInstances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.gamelift.model.GameServerInstance.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NonZeroAndMaxString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.gamelift.model.primitives.NonZeroAndMaxString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse
  ): zio.aws.gamelift.model.DescribeGameServerInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
