package zio.aws.gamelift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.gamelift.model.primitives.IdStringModel
import scala.jdk.CollectionConverters._
final case class DescribeGameSessionPlacementRequest(
    placementId: IdStringModel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementRequest = {
    import DescribeGameSessionPlacementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementRequest
      .builder()
      .placementId(IdStringModel.unwrap(placementId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.gamelift.model.DescribeGameSessionPlacementRequest.ReadOnly =
    zio.aws.gamelift.model.DescribeGameSessionPlacementRequest
      .wrap(buildAwsValue())
}
object DescribeGameSessionPlacementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.gamelift.model.DescribeGameSessionPlacementRequest =
      zio.aws.gamelift.model.DescribeGameSessionPlacementRequest(placementId)
    def placementId: IdStringModel
    def getPlacementId: ZIO[Any, Nothing, IdStringModel] =
      ZIO.succeed(placementId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementRequest
  ) extends zio.aws.gamelift.model.DescribeGameSessionPlacementRequest.ReadOnly {
    override val placementId: IdStringModel =
      zio.aws.gamelift.model.primitives.IdStringModel(impl.placementId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementRequest
  ): zio.aws.gamelift.model.DescribeGameSessionPlacementRequest.ReadOnly =
    new Wrapper(impl)
}
